﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework;

namespace CashierCrisis.Managers
{
    public class InputManager : GameComponent
    {
        PlayerIndex _playerIndex = PlayerIndex.One;
        GamePadState _currentGamePadState;
        GamePadState _lastGamePadState;
        KeyboardState _currentKeyBoardState;
        KeyboardState _lastKeyBoardState;
        public bool firstFrame = true;
       
        public PlayerIndex Player
        {
            get { return _playerIndex; }
            set { _playerIndex = value; }
        }

        public bool Connected
        {
            get { return _currentGamePadState.IsConnected; }
        }

        public InputManager(Game game)
            :base(game)
        {

        }

        public bool IsNewKeyPress(Keys key)
        {
            return (_currentKeyBoardState.IsKeyDown(key) && _lastKeyBoardState.IsKeyUp(key));
        }

        public bool IsKeyPressed(Keys key)
        {
            return (_currentKeyBoardState.IsKeyDown(key) && _lastKeyBoardState.IsKeyDown(key));
        }

        public bool IsNewButtonPress(Buttons button)
        {
            return (_currentGamePadState.IsButtonDown(button) && _lastGamePadState.IsButtonUp(button)) ;
        }

        public bool IsButtonPressed(Buttons button)
        {
            return (_currentGamePadState.IsButtonDown(button));
        }

        public bool UpButton()
        {
            bool keyUp = false;
#if !XBOX
            keyUp = IsNewKeyPress(Keys.Up) || IsNewKeyPress(Keys.W);
#endif

            return IsNewButtonPress(Buttons.DPadUp) || IsNewButtonPress(Buttons.LeftThumbstickUp) || keyUp;
        }

        public bool DownButton()
        {
            bool keyDown = false;
#if !XBOX
            keyDown = IsNewKeyPress(Keys.Down) || IsNewKeyPress(Keys.S);
#endif
            return IsNewButtonPress(Buttons.DPadDown) || IsNewButtonPress(Buttons.LeftThumbstickDown) || keyDown;
        }

        public bool LeftButton()
        {
            bool keyLeft = false;
#if !XBOX
            keyLeft = IsNewKeyPress(Keys.Left) || IsNewKeyPress(Keys.A);
#endif
            return IsNewButtonPress(Buttons.DPadLeft) || IsNewButtonPress(Buttons.LeftThumbstickLeft) || keyLeft;
        }

        public bool RightButton()
        {
            bool keyRight = false;
#if !XBOX
            keyRight = IsNewKeyPress(Keys.Right) || IsNewKeyPress(Keys.D);
#endif
            return IsNewButtonPress(Buttons.DPadRight) || IsNewButtonPress(Buttons.LeftThumbstickRight) || keyRight;
        }

        public bool ConfirmButton()
        {
            bool keyConfirm = false;
#if !XBOX
            keyConfirm = IsNewKeyPress(Keys.Enter) || IsNewKeyPress(Keys.Space);
#endif
            if (firstFrame)
            {
                firstFrame = false;
                return false;
            }
            else
            return IsNewButtonPress(Buttons.A) || keyConfirm;
        }

        public bool BackButton()
        {
            bool keyBack = false;
#if !XBOX
            keyBack = IsNewKeyPress(Keys.Back) || IsNewKeyPress(Keys.Escape);
#endif
            return IsNewButtonPress(Buttons.B) || IsNewButtonPress(Buttons.Back) || keyBack;
        }

        public bool PauseButton()
        {
            bool keyPause = false;
#if !XBOX
            keyPause = IsNewKeyPress(Keys.Enter) || IsNewKeyPress(Keys.Escape);
#endif
            return IsNewButtonPress(Buttons.Start) || keyPause;
        }

        public override void Update(GameTime gameTime)
        {
            _lastGamePadState = _currentGamePadState;
            _currentGamePadState = GamePad.GetState(_playerIndex);
#if !XBOX
            _lastKeyBoardState = _currentKeyBoardState;
            _currentKeyBoardState = Keyboard.GetState();
#endif
        }


    }
}
